
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Nov 29 18:42:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version ODRM_TLK_ATP_menu.c#1:csrc:1
   *  \author Sagitb
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/***** Include Files **************/
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Stdio.h"
#include "MW_ATP_UTIL_funcs.h"
#include "KMNG_Defs.h"
#include "KMNG_API.h" 
#include "tlk_odrm_version.h"
#include "ODRM_SecROHandling_data.h"
#include "ODRM_SecROHandling_JoinDomain_ATP.h"
#include "ODRM_SecROHandling_RoPreProcessing_ATP.h"
#include "ODRM_SecROHandling_RoActivation_ATP.h"

/******** Defines ************/

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_ODRM_Run_All_Tests      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function runs all the tests
*  
******************************************************************************/
DxError_t TST_ATP_SecRO_ODRM_Run_All_Tests( void )
{
  /********* TST Variables Definitions ************/
  DxError_t          TST_Error = DX_SUCCESS, TST_TempError = DX_SUCCESS;

  ATP_LOG_TST_PRINT((MW_ATP_MSG,"******************************************************* \n"));
  ATP_LOG_TST_PRINT((MW_ATP_MSG,"************ Run All KMNG ATP tests ******************* \n"));      
  ATP_LOG_TST_PRINT((MW_ATP_MSG,"******************************************************* \n \n"));

  /* Initializing the KMNG in case this function is called w/o the menu
	 multiple calls to KMNG_Init are assumed to have no effect.	        */
  TST_Error = KMNG_Init();
 TST_ATP_CHECK_ERROR_RETURN(TST_Error,
											   "KMNG_Init",
											   "TST_ATP_SecRO_ODRM_Run_All_Tests",
											   "TST_ATP_SecRO_ODRM_Run_All_Tests");

  TST_Error = TST_ATP_SEC_RO_JoinDomainProcess();
  TST_TempError = TST_TempError + TST_Error;
 
  TST_Error = TST_ATP_SEC_RO_InvalidKeyInJoinDomain();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_InvalidUsageFlagInJoinDomain();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_PreProcessingAndActivation();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_ActivationTwoConstr();
  TST_TempError = TST_TempError + TST_Error;
 
  TST_Error = TST_ATP_SEC_RO_ExpiredROActivation();
  TST_TempError = TST_TempError + TST_Error;


  TST_Error = TST_ATP_SEC_RO_PreProcessingWithInvalidFlag();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_PreProcessingWithInvalidRO();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_DomainRoInstWithInvalidFlag();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_DomainRoInstWithInvalidKey();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_DomainRoInstWithInvPassword();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_ParentChiledROActivation();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_GroupROActivation();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_ROActivationWithInvGroupKey();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_InvalidROActivation();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_SEC_RO_InvalidParentROActivation();
  TST_TempError = TST_TempError + TST_Error;
  
    

  /*Check if all tests pass*/
  if (TST_TempError != TST_PASS )
  {
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!! ONE OR MORE OF THE ATP TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
	return TST_FAIL;
  }
  else
  {
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n \n**********************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"* ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP ***\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"**********************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"*** ALL OF THE ATP  TESTS PASS     :-)         *****\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"**********************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"* ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP ***\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"**********************\n"));
  }

EXIT_ON_ERROR:
  return TST_Error;
}
/*****************************************************************************
* Function Name:                                                           
*  ODRM_TLK_ATP_menu      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function runs the ATP menu
*  
******************************************************************************/

 DxError_t ODRM_SecROHandling_ATP_menu (void)

 {

   DxInt_t     Var;
   DxStatus TST_TestStatus = DX_SUCCESS;
   TLK_ODRMVersion_t TST_Version;

    #ifdef _DEBUG
        TST_TestStatus =  DX_VOS_DbgPrint_SetDebugLevel(0);
    #endif

      TST_TestStatus = KMNG_Init();
      
      TST_ATP_CHECK_ERROR_RETURN(TST_TestStatus,"KMNG_Init",
                                                       "ODRM_SecROHandling_ATP_menu",
                                                       "ODRM_SecROHandling_ATP_menu");
     


        TST_TestStatus =TLK_ODRM_VersionGet(&TST_Version);

        TST_ATP_CHECK_ERROR_RETURN(TST_TestStatus,
                        "TLK_ODRM_VersionGet",
                        "ODRM_SecROHandling_ATP_menu",
                        "ODRM_SecROHandling_ATP_menu");
       
    
        ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n-----------------------------------------------------"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n------------[OMA DRM Toolkit Version]----------------"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n-----------------------------------------------------"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n %s %c.%d.%d.%d",TST_Version.tlk_odrm.componentName,
        														   TST_Version.tlk_odrm.typeVer,
        														   TST_Version.tlk_odrm.majorVer,
        														   TST_Version.tlk_odrm.minorVer,
        														   TST_Version.tlk_odrm.subVer));
        ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n-----------------------------------------------------"));

      while(1)
      {
        while(1)
        {
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n\n              -- DISCRETIX LTD 2007 --           "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       -- OMA DRM Toolkit Acceptance tests --        "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------[ Main Tests Menu ]-----------------"));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [1] - Join Domain Process test  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [2] - Invalid Key In JoinDomain test "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [3] - Invalid Usage Flag of Device Key In Join-Domain process  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [4] - RO PreProcessing And Activation  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [5] - RO PreProcessing And Activation with expired and valid constrains "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [6] - Expired RO Activation test  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [7] - RO PreProcessing With Invalid Flag test  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [8] - PreProcessing With Invalid RO Integrity test"));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [9] - Domain Ro PreProcessing With Invalid Flag test "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [A] - Domain Ro PreProcessing With Invalid Key test "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [B] - Domain Ro PreProcessing With Invalid Password test "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [C] - Parent-Chiled RO Activation test "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [D] - Group RO Activation test "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [E] - RO Activation With Invalid Group Key test "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [F] - Invalid RO Activation test "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [G] - Invalid Parent RO Activation test "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [T] - Run all tests "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [Z] - End Of Tests  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n"));
         
          GET_NON_WHITE_SPACE_CHAR(Var);

          DX_VOS_Printf("\n Test = %c\n",Var);

          if (Var<='z')
            break;
          else
            DX_VOS_Printf("\n Error[%d]  Please select '1'-'XX'\n\n",Var);
        }

        switch(Var)
        {
        case '1':
          TST_ATP_SEC_RO_JoinDomainProcess();
          break;
        case '2':
          TST_ATP_SEC_RO_InvalidKeyInJoinDomain();
          break;
        case '3':
          TST_ATP_SEC_RO_InvalidUsageFlagInJoinDomain();
          break;
        case '4':
          TST_ATP_SEC_RO_PreProcessingAndActivation();
          break;
        case '5':
            TST_ATP_SEC_RO_ActivationTwoConstr();
            break;  
        case '6':
          TST_ATP_SEC_RO_ExpiredROActivation();
          break;
        case '7':
          TST_ATP_SEC_RO_PreProcessingWithInvalidFlag();
          break;
        case '8':
          TST_ATP_SEC_RO_PreProcessingWithInvalidRO();
          break;
        case '9':
            TST_ATP_SEC_RO_DomainRoInstWithInvalidFlag();
            break;
        case 'A':
            TST_ATP_SEC_RO_DomainRoInstWithInvalidKey();
            break;
        case 'B':
            TST_ATP_SEC_RO_DomainRoInstWithInvPassword();
            break;
        case 'C':
            TST_ATP_SEC_RO_ParentChiledROActivation();
            break;
        case 'D':
            TST_ATP_SEC_RO_GroupROActivation();
            break;
        case 'E':
            TST_ATP_SEC_RO_ROActivationWithInvGroupKey();
            break;
        case 'F':
            TST_ATP_SEC_RO_InvalidROActivation();
            break;
        case 'G':
             TST_ATP_SEC_RO_InvalidParentROActivation();
            break;
        case 'T':
            TST_ATP_SecRO_ODRM_Run_All_Tests();
            break;
            
        }

        if(Var =='Z')
          break;
      }

EXIT_ON_ERROR:  

  return TST_TestStatus;
  
}



